<?php
/**
 * Plugin Name:           AutomatorWP - Twitter
 * Plugin URI:            https://automatorwp.com/add-ons/twitter/
 * Description:           Connect AutomatorWP with Twitter.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-twitter
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Twitter
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Twitter {

    /**
     * @var         AutomatorWP_Twitter $instance The one true AutomatorWP_Twitter
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Twitter self::$instance The one true AutomatorWP_Twitter
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Twitter();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_TWITTER_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_TWITTER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_TWITTER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_TWITTER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Libs
            require_once AUTOMATORWP_TWITTER_DIR . 'libs/twitter-for-php/twitter.class.php';

            // Includes
            require_once AUTOMATORWP_TWITTER_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_TWITTER_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_TWITTER_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_TWITTER_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_TWITTER_DIR . 'includes/actions/send-tweet.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'twitter', array(
            'label' => 'Twitter',
            'icon'  => AUTOMATORWP_TWITTER_URL . 'assets/twitter.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Twitter instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Twitter The one true AutomatorWP_Twitter
 */
function AutomatorWP_Twitter() {
    return AutomatorWP_Twitter::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Twitter' );
